// Fit all streg models
// stored results
//    - rmst at 3 years
//    - mean survival
//    - AIC/BIC
//    - convergence


clear


cd "C:\TSD_simulation\Analysis_of_simulations\Standard_streg_models"

// program to extract results from streg models
capture program drop get_streg_results
program define get_streg_results
	syntax, dist(string)
	capture drop s3 s80
	
	// rmst3
	drop _t
	range _t 0 3 500
	replace _t0=0
	predict s3, surv
	capture integ s3 _t
	c_local rmst3_`dist' = cond("`r(integral)'"!="","`r(integral)'",".")
	
	// meansurv
	drop _t
	range _t 0 80 500
	predict s80, surv
	capture integ s80 _t	
	c_local meansurv_`dist' = cond("`r(integral)'"!="","`r(integral)'",".")
	replace _t = old_t
	
	// AIC and BIC
	count if _d == 1
	capture estat ic, n(`r(N)')
	c_local AIC_`dist' = cond(`e(converged)',el(r(S),1,5),.)
	c_local BIC_`dist' = cond(`e(converged)',el(r(S),1,6),.)
	
	// convergence
	c_local converged_`dist' `e(converged)'
end


// simulation number
local j 1 
// scenario
foreach scen in 1 2 3 4 {
	// sample size 
	foreach ss in 100 500 {
		// Low and medium survival
		foreach S in 1 2 {
		// Different frailty effects
			foreach F in 1 1 2 {
				di _newline "Scenario`scen'_S`S'_SS`ss'_F`F'"
				quietly {
					//postfile
					postutil clear
					local newvars
					foreach  dist in exp weibull lnormal llogistic gompertz ggamma {
						foreach x in rmst3 meansurv AIC BIC converged {
							local newvars `newvars' `x'_`dist'
						}
					}
					postfile stregsim `newvars' using Scenario`scen'_S`S'_SS`ss'_F`F'.dta,replace
					
					// loop over datasets
					forvalues j = 1/1000 {
						// load and analyse
						use ../../Simulated_Data/Scenario`scen'_S`S'_SS`ss'_F`F'/sim`j', clear
						stset t d
						clonevar old_t = _t
						foreach dist in exp weibull lnormal llogistic gompertz ggamma {
							// fit model and get results
							capture streg , dist(`dist') iter(20)
							get_streg_results, dist(`dist')
						}
						// post values
						local postvals
						foreach dist in exp weibull lnormal llogistic gompertz ggamma {
							foreach x in rmst3 meansurv AIC BIC converged {
								local postvals `postvals' (``x'_`dist'')
							}					
						}
						post stregsim `postvals'
						noisily di "." _continue
					}
					postclose stregsim
				}
			}
		}
	}
}


